<?php

namespace App\Http\Resources\Web;

use Illuminate\Http\Resources\Json\JsonResource;

class ServiceReviewsResource extends JsonResource
{
    public static $wrap = null;
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $customer = $this->relationLoaded('customer') ? $this->whenLoaded('customer'):null;
        $therapist = $this->relationLoaded('therapist') ? $this->whenLoaded('therapist'):null;
        $therapist_community = $this->relationLoaded('therapist_community') ? $this->whenLoaded('therapist_community'):null;
        $service = $this->relationLoaded('service') ? $this->whenLoaded('service'):null;
        return [
                "id" =>  $this->id,
                "rating" =>  $this->rating,
                "experience" =>  $this->experience,
                "communication" =>  $this->communication,
                "service" =>  $this->service,
                "comment" =>  $this->comment,
                "is_active" =>  $this->is_active,
                "customer" =>[
                    "id" => $customer->id,
                    "name" => $customer->name ?? '',
                    "image" => $customer->image ?? '',
                ],
                "therapist_community" =>[
                    "id" => $therapist_community->id,
                    "name" => $therapist_community->name ?? '',
                    "image" => $therapist_community->image ?? '',
                ],
                "therapist" =>[
                    "id" => $therapist->id,
                    "name" => $therapist->name ?? '',
                    "image" => $therapist->image ?? '',
                ],
                "created_at" =>  $this->created_at,
                "updated_at" =>  $this->updated_at,
        ];
    }
}
